/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.runtime;

import com.google.common.base.Suppliers;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import dev.architectury.platform.Platform;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.RoughlyEnoughItemsCoreClient;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.favorites.FavoriteEntryType;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponent;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponentProviderWidget;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponentVisitorWidget;
import me.shedaniel.rei.api.client.gui.screen.DisplayScreen;
import me.shedaniel.rei.api.client.gui.widgets.Panel;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.gui.widgets.utils.PanelTextures;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.client.registry.screen.ExclusionZones;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.client.search.method.InputMethodRegistry;
import me.shedaniel.rei.api.client.util.ClientEntryStacks;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.plugins.REIPlugin;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.ClientHelperImpl;
import me.shedaniel.rei.impl.client.REIRuntimeImpl;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.screen.DefaultDisplayViewingScreen;
import me.shedaniel.rei.impl.client.gui.widget.AutoCraftingEvaluator;
import me.shedaniel.rei.impl.client.gui.widget.DisplayCompositeWidget;
import me.shedaniel.rei.impl.client.gui.widget.DisplayTooltipComponent;
import me.shedaniel.rei.impl.client.gui.widget.favorites.FavoritesListWidget;
import me.shedaniel.rei.impl.client.search.method.DefaultInputMethod;
import me.shedaniel.rei.impl.client.search.method.unihan.BomopofoInputMethod;
import me.shedaniel.rei.impl.client.search.method.unihan.DoublePinyinInputMethod;
import me.shedaniel.rei.impl.client.search.method.unihan.JyutpingInputMethod;
import me.shedaniel.rei.impl.client.search.method.unihan.PinyinInputMethod;
import me.shedaniel.rei.impl.client.search.method.unihan.UniHanManager;
import me.shedaniel.rei.impl.common.InternalLogger;
import me.shedaniel.rei.impl.common.entry.type.EntryRegistryImpl;
import me.shedaniel.rei.impl.common.entry.type.EntryRegistryListener;
import me.shedaniel.rei.impl.common.util.HNEntryStackWrapper;
import me.shedaniel.rei.plugin.client.runtime.FilteredStacksVisibilityHandler;
import me.shedaniel.rei.plugin.client.runtime.InputMethodWatcher;
import me.shedaniel.rei.plugin.client.runtime.PluginStageExecutionWatcher;
import me.shedaniel.rei.plugin.client.runtime.SearchBarHighlightWatcher;
import me.shedaniel.rei.plugin.client.runtime.SearchFilterPrepareWatcher;
import me.shedaniel.rei.plugin.client.runtime.SearchFilterWatcher;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
@ApiStatus.Internal
public class DefaultClientRuntimePlugin
implements REIClientPlugin {
    private final FilteredStacksVisibilityHandler filteredStacksVisibilityHandler = new FilteredStacksVisibilityHandler();

    public DefaultClientRuntimePlugin() {
        PluginStageExecutionWatcher watcher = new PluginStageExecutionWatcher();
        for (PluginManager<REIPlugin<?>> instance : PluginManager.getActiveInstances()) {
            instance.registerReloadable(watcher.reloadable(instance));
        }
        REIRuntimeImpl.getInstance().addHintProvider(watcher);
        REIRuntimeImpl.getInstance().addHintProvider(new SearchBarHighlightWatcher());
        REIRuntimeImpl.getInstance().addHintProvider(new SearchFilterPrepareWatcher());
        REIRuntimeImpl.getInstance().addHintProvider(new SearchFilterWatcher());
        REIRuntimeImpl.getInstance().addHintProvider(new InputMethodWatcher());
    }

    @Override
    public void registerEntries(EntryRegistry registry) {
        if (ClientHelperImpl.getInstance().isAprilFools.get().booleanValue()) {
            registry.addEntry(ClientEntryStacks.of(new Renderer(this){
                private final class_2960 id = class_2960.method_60655((String)"roughlyenoughitems", (String)"textures/gui/kirb.png");

                @Override
                public void render(class_332 graphics, Rectangle bounds, int mouseX, int mouseY, float delta) {
                    graphics.method_25295(class_10799.field_56883, this.id, bounds.x, bounds.getMaxX(), bounds.y, bounds.getMaxY(), 0.0f, 0.0f, 1.0f, 0.0f, 1);
                }

                @Override
                @Nullable
                public Tooltip getTooltip(TooltipContext context) {
                    return Tooltip.create(context.getPoint(), new class_2561[]{class_2561.method_43470((String)"Kirby"), ClientHelper.getInstance().getFormattedModFromModId("Dream Land")});
                }
            }));
        }
        ((EntryRegistryImpl)registry).listeners.add(new EntryRegistryListener(){

            @Override
            public void onReFilter(List<HNEntryStackWrapper> stacks) {
                DefaultClientRuntimePlugin.this.filteredStacksVisibilityHandler.reset();
            }
        });
    }

    @Override
    public void registerDisplays(DisplayRegistry registry) {
        this.filteredStacksVisibilityHandler.reset();
        registry.registerVisibilityPredicate(this.filteredStacksVisibilityHandler);
    }

    @Override
    public void registerScreens(ScreenRegistry registry) {
        ExclusionZones zones = registry.exclusionZones();
        zones.register(DefaultDisplayViewingScreen.class, screen -> {
            Panel widget = screen.getWorkingStationsBaseWidget();
            if (widget == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(widget.getBounds().clone());
        });
        zones.register(class_437.class, screen -> {
            FavoritesListWidget widget = ScreenOverlayImpl.getFavoritesListWidget();
            if (widget != null && widget.togglePanelButton.isVisible()) {
                return Collections.singletonList(widget.togglePanelButton.bounds);
            }
            return Collections.emptyList();
        });
        registry.registerDraggableComponentProvider(DraggableComponentProviderWidget.from(context -> {
            if (RoughlyEnoughItemsCoreClient.shouldReturn(context.getScreen()) || !REIRuntime.getInstance().isOverlayVisible()) {
                return Collections.emptyList();
            }
            return Widgets.walk(REIRuntime.getInstance().getOverlay().get().method_25396(), DraggableComponentProviderWidget.class::isInstance);
        }));
        registry.registerDraggableComponentVisitor(DraggableComponentVisitorWidget.from(context -> {
            if (RoughlyEnoughItemsCoreClient.shouldReturn(context.getScreen()) || !REIRuntime.getInstance().isOverlayVisible()) {
                return Collections.emptyList();
            }
            return Widgets.walk(REIRuntime.getInstance().getOverlay().get().method_25396(), DraggableComponentVisitorWidget.class::isInstance);
        }));
    }

    @Override
    public void registerFavorites(FavoriteEntryType.Registry registry) {
        registry.register(EntryStackFavoriteType.INSTANCE.id, EntryStackFavoriteType.INSTANCE);
        registry.register(DisplayFavoriteType.INSTANCE.id, DisplayFavoriteType.INSTANCE);
    }

    @Override
    public void registerInputMethods(InputMethodRegistry registry) {
        registry.add(DefaultInputMethod.ID, DefaultInputMethod.INSTANCE);
        UniHanManager manager = new UniHanManager(Platform.getConfigFolder().resolve("roughlyenoughitems/unihan.zip"));
        registry.add(class_2960.method_60654((String)"rei:pinyin"), new PinyinInputMethod(manager));
        registry.add(class_2960.method_60654((String)"rei:jyutping"), new JyutpingInputMethod(manager));
        registry.add(class_2960.method_60654((String)"rei:bomopofo"), new BomopofoInputMethod(manager));
        registry.add(class_2960.method_60654((String)"rei:double_pinyin"), new DoublePinyinInputMethod(manager));
    }

    private static enum EntryStackFavoriteType implements FavoriteEntryType<EntryStackFavoriteEntry>
    {
        INSTANCE(FavoriteEntryType.ENTRY_STACK);

        private final String key = "data";
        private final class_2960 id;

        private EntryStackFavoriteType(class_2960 id) {
            this.id = id;
        }

        @Override
        public DataResult<EntryStackFavoriteEntry> read(class_2487 object) {
            try {
                return EntryStack.codec().parse((DynamicOps)BasicDisplay.registryAccess().method_57093((DynamicOps)class_2509.field_11560), (Object)((class_2520)object.method_10562("data").orElseThrow())).map(EntryStackFavoriteEntry::new).setLifecycle(Lifecycle.stable());
            }
            catch (Throwable throwable) {
                return DataResult.error(throwable::getMessage);
            }
        }

        @Override
        public DataResult<EntryStackFavoriteEntry> fromArgs(Object ... args) {
            if (args.length == 0) {
                return DataResult.error(() -> "Cannot create EntryStackFavoriteEntry from empty args!");
            }
            Object object = args[0];
            if (!(object instanceof EntryStack)) {
                return DataResult.error(() -> "Creation of EntryStackFavoriteEntry from args expected EntryStack as the first argument!");
            }
            EntryStack stack = (EntryStack)object;
            if (!stack.supportSerialization()) {
                return DataResult.error(() -> "Creation of EntryStackFavoriteEntry from an unserializable stack!");
            }
            return DataResult.success((Object)new EntryStackFavoriteEntry(stack), (Lifecycle)Lifecycle.stable());
        }

        @Override
        public class_2487 save(EntryStackFavoriteEntry entry, class_2487 tag) {
            tag.method_10566("data", (class_2520)EntryStack.codec().encodeStart((DynamicOps)BasicDisplay.registryAccess().method_57093((DynamicOps)class_2509.field_11560), entry.stack).getOrThrow());
            return tag;
        }
    }

    private static enum DisplayFavoriteType implements FavoriteEntryType<DisplayFavoriteEntry>
    {
        INSTANCE(FavoriteEntryType.DISPLAY);

        private final String key = "data";
        private final class_2960 id;

        private DisplayFavoriteType(class_2960 id) {
            this.id = id;
        }

        @Override
        public DataResult<DisplayFavoriteEntry> read(class_2487 object) {
            try {
                if (object.method_10545("Data")) {
                    DataResult result = Display.codec().parse((DynamicOps)BasicDisplay.registryAccess().method_57093((DynamicOps)class_2509.field_11560), (Object)((class_2520)object.method_10562("Data").orElseThrow()));
                    return DataResult.success((Object)new DisplayFavoriteEntry((Display)result.getOrThrow(), UUID.fromString((String)object.method_10558("UUID").orElseThrow())), (Lifecycle)Lifecycle.stable());
                }
                return DataResult.success((Object)new DisplayFavoriteEntry(null, UUID.fromString((String)object.method_10558("UUID").orElseThrow())), (Lifecycle)Lifecycle.stable());
            }
            catch (Throwable throwable) {
                return DataResult.error(throwable::getMessage);
            }
        }

        @Override
        public DataResult<DisplayFavoriteEntry> fromArgs(Object ... args) {
            if (args.length == 0) {
                return DataResult.error(() -> "Cannot create DisplayFavoriteEntry from empty args!");
            }
            Object object = args[0];
            if (!(object instanceof Display)) {
                return DataResult.error(() -> "Creation of DisplayFavoriteEntry from args expected Display as the first argument!");
            }
            Display display = (Display)object;
            return DataResult.success((Object)new DisplayFavoriteEntry(display, UUID.randomUUID()), (Lifecycle)Lifecycle.stable());
        }

        @Override
        public class_2487 save(DisplayFavoriteEntry entry, class_2487 tag) {
            boolean hasSerializer = entry.display.getSerializer() != null;
            tag.method_10582("CategoryID", entry.display.getCategoryIdentifier().toString());
            tag.method_10582("UUID", entry.uuid.toString());
            if (hasSerializer) {
                try {
                    DataResult displayTag = Display.codec().encodeStart((DynamicOps)BasicDisplay.registryAccess().method_57093((DynamicOps)class_2509.field_11560), (Object)entry.display);
                    tag.method_10566("Data", (class_2520)displayTag.getOrThrow());
                }
                catch (Exception e) {
                    InternalLogger.getInstance().warn("Failed to save display favorite entry", e);
                }
            }
            return tag;
        }
    }

    private static class DisplayFavoriteEntry
    extends FavoriteEntry {
        private static final Function<EntryStack<?>, String> CANCEL_FLUID_AMOUNT = s -> null;
        private final Supplier<DisplayTooltipComponent> tooltipComponent;
        private final Display display;
        private final UUID uuid;
        private final long hash;

        public DisplayFavoriteEntry(Display display, UUID uuid) {
            this.display = display;
            this.uuid = uuid;
            this.hash = uuid.hashCode();
            this.tooltipComponent = Suppliers.memoize(() -> new DisplayTooltipComponent(display));
        }

        @Override
        public UUID getUuid() {
            return this.uuid;
        }

        @Override
        public boolean isInvalid() {
            return this.display == null;
        }

        @Override
        public Renderer getRenderer(boolean showcase) {
            final Panel panel = Widgets.createRecipeBase(new Rectangle(0, 0, 18, 18)).texture(PanelTextures.LIGHTER);
            final Slot slot = Widgets.createSlot(new Rectangle()).disableBackground().disableHighlight().disableTooltips();
            for (EntryIngredient ingredient : this.display.getOutputEntries()) {
                slot.entries(ingredient);
            }
            return new Renderer(){

                @Override
                public void render(class_332 graphics, Rectangle bounds, int mouseX, int mouseY, float delta) {
                    graphics.method_51448().pushMatrix();
                    graphics.method_51448().translate((float)bounds.getX(), (float)bounds.getY());
                    graphics.method_51448().scale((float)bounds.width / (float)panel.getBounds().getWidth(), (float)bounds.height / (float)panel.getBounds().getHeight());
                    panel.method_25394(graphics, mouseX, mouseY, delta);
                    graphics.method_51448().popMatrix();
                    if (bounds.width > 4 && bounds.height > 4) {
                        graphics.method_51448().pushMatrix();
                        graphics.method_51448().translate(0.0f, 0.5f);
                        slot.getBounds().setBounds(bounds.x + 2, bounds.y + 2, bounds.width - 4, bounds.height - 4);
                        slot.method_25394(graphics, mouseX, mouseY, delta);
                        graphics.method_51448().popMatrix();
                    }
                }

                @Override
                @Nullable
                public Tooltip getTooltip(TooltipContext context) {
                    Tooltip tooltip = Tooltip.create(context.getPoint(), new class_2561[0]);
                    tooltip.add(tooltipComponent.get());
                    tooltip.add((class_2561)class_2561.method_43471((String)"text.auto_craft.move_items.tooltip").method_27692(class_124.field_1054));
                    return tooltip;
                }
            };
        }

        @Override
        public boolean doAction(class_11909 event) {
            Widgets.produceClickSound();
            if (!(class_310.method_1551().field_1755 instanceof DisplayScreen) && event.method_74240()) {
                AutoCraftingEvaluator.evaluateAutoCrafting(true, event.method_74239(), this.display, Collections::emptyList);
                return true;
            }
            ClientHelperImpl.getInstance().openDisplayViewingScreen(Map.of(CategoryRegistry.getInstance().get(this.display.getCategoryIdentifier()).getCategory(), List.of(this.display)), null, List.of(), List.of());
            return true;
        }

        @Override
        public long hashIgnoreAmount() {
            return this.hash;
        }

        @Override
        public FavoriteEntry copy() {
            return new DisplayFavoriteEntry(this.display, this.uuid);
        }

        @Override
        public class_2960 getType() {
            return DisplayFavoriteType.INSTANCE.id;
        }

        @Override
        public boolean isSame(FavoriteEntry other) {
            if (!(other instanceof DisplayFavoriteEntry)) {
                return false;
            }
            DisplayFavoriteEntry that = (DisplayFavoriteEntry)other;
            return Objects.equals(this.uuid, that.uuid);
        }

        @Override
        @Nullable
        public DraggableComponent<?> asDraggableComponent(Slot slot) {
            CategoryRegistry.CategoryConfiguration<?> configuration = CategoryRegistry.getInstance().get(this.display.getCategoryIdentifier());
            DisplayCategory<?> category = configuration.getCategory();
            Rectangle displayBounds = new Rectangle(0, 0, category.getDisplayWidth(this.display), category.getDisplayHeight());
            List<Widget> widgets = configuration.getView(this.display).setupDisplay(this.display, displayBounds);
            DisplayCompositeWidget.DisplayDraggableComponent component = new DisplayCompositeWidget.DisplayDraggableComponent(Widgets.concat(CollectionUtils.filterToList(widgets, w -> !(w instanceof Panel))), this.display, slot.getInnerBounds(), displayBounds);
            component.onFavoritesRegion = true;
            return component;
        }
    }

    private static class EntryStackFavoriteEntry
    extends FavoriteEntry {
        private static final Function<EntryStack<?>, String> CANCEL_FLUID_AMOUNT = s -> null;
        private final EntryStack<?> stack;
        private final long hash;

        public EntryStackFavoriteEntry(EntryStack<?> stack) {
            this.stack = stack.normalize();
            this.hash = EntryStacks.hashExact(this.stack);
        }

        @Override
        public boolean isInvalid() {
            return this.stack.isEmpty();
        }

        @Override
        public Renderer getRenderer(boolean showcase) {
            return this.stack;
        }

        @Override
        public boolean doAction(class_11909 event) {
            return false;
        }

        @Override
        public long hashIgnoreAmount() {
            return this.hash;
        }

        @Override
        public FavoriteEntry copy() {
            return new EntryStackFavoriteEntry(this.stack.normalize());
        }

        @Override
        public class_2960 getType() {
            return EntryStackFavoriteType.INSTANCE.id;
        }

        @Override
        public boolean isSame(FavoriteEntry other) {
            if (!(other instanceof EntryStackFavoriteEntry)) {
                return false;
            }
            EntryStackFavoriteEntry that = (EntryStackFavoriteEntry)other;
            return EntryStacks.equalsExact(this.stack, that.stack);
        }
    }
}

